// (C)1997 Christian Janoff
// DUMP.CC

#include <iomanip.h> // fuer setw
#include "c1541.h"
#include "dump.h"

void c1541disk::dump_sector(int trk, int sec)
{
 int i,j,c;

 cout << "TRACK" << trk << " SECTOR " << sec << ":" << endl;

 for(i=0;i<16;i++)
   {
     for(j=0;j<16;j++)
       {
	 c = get_byte(trk,sec,j+16*i);
	 cout << setw(3) << c << " ";
       }
     for(j=0;j<16;j++)
       {
	 c = get_byte(trk,sec,j+16*i);
	 if (pet2isoexact(c)) cout << (char)c;
	   else cout << ".";
       }
     cout << endl;
   }
}

int pet2isoexact(int code)
{
  int pet[256]={ 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,   //  0-15
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,   // 16-31
		 ' ' , '!' , '"' , '#' , '$' , '%' , '&' ,  39 , '(' , ')' , '*' , '+' , ',' , '-' , '.' , '/' , // 32-47
		 '0' , '1' , '2' , '3' , '4' , '5' , '6' , '7' , '8' , '9' , ':' , ';' , '<' , '=' , '>' , '?' , // 48-63
		 '@' , 'a' , 'b' , 'c' , 'd' , 'e' , 'f' , 'g' , 'h' , 'i' , 'j' , 'k' , 'l' , 'm' , 'n' , 'o' , // 64-79
		 'p' , 'q' , 'r' , 's' , 't' , 'u' , 'v' , 'w' , 'x' , 'y' , 'z' , '[' , '' , ']' ,   0 ,   0 , // 80-95
		   0 , 'A' , 'B' , 'C' , 'D' , 'E' , 'F' , 'G' , 'H' , 'I' , 'J' , 'K' , 'L' , 'M' , 'N' , 'O' , // 96-111
                 'P' , 'Q' , 'R' , 'S' , 'T' , 'U' , 'V' , 'W' , 'X' , 'Y' , 'Z' ,   0 ,   0 ,   0 ,   0 ,   0 , // 112-127
		 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,   // 128-143
		 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,   // 144-159
	       ' ',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,   // 160-175
		 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,   // 176-191
		 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,   // 192-207
		 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,   // 208-223
	       ' ',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,   // 224-239
		 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0    // 240-255
  };

  return pet[code];
}

